property pContentView : missing value
property pParameters : missing value


on run {input, parameters}
	if input is not {} then
		if the class of input is list then
			set vAddDate to (|addDate| of parameters) as integer
			set vChosenPlaylistName to (|chosenPlaylistName| of parameters)
			set vNewPlaylistName to (|newPlaylistName| of parameters)
			set vWhichPlaylist to (|whichPlaylist| of parameters) as integer
			
			tell application "iTunes"
				if vWhichPlaylist is 0 then
					set noCoverPlaylist to (a reference to playlist vChosenPlaylistName)
				else
					set noCoverPlaylist to make new playlist
					
					if vAddDate is 1 then
						set the name of noCoverPlaylist to (vNewPlaylistName & " " & (current date) as string)
					else
						set the name of noCoverPlaylist to vNewPlaylistName
					end if
				end if
				
				set fx to fixed indexing
				set fixed indexing to true
				copy (count of input) to idx
				
				repeat with j from 1 to idx
					set theTrack to (a reference to item j of input)
					
					if (count of artworks of theTrack) < 1 then
						duplicate theTrack to noCoverPlaylist
					end if
				end repeat
				
				set fixed indexing to fx
			end tell
		end if
	end if
	
	return input
end run


on awake from nib theObject
	set theName to the name of theObject
	if theName is "guiAutomatorView" then
		set pContentView to theObject
		set pParameters to (call method "parameters" of (call method "action" of (the super view of theObject)))
	end if
end awake from nib


on parameters updated theObject parameters theParameters
	set |chosenPlaylistName| of theParameters to (the title of popup button "guiExistingPlaylists" of the pContentView) as Unicode text
	return theParameters
end parameters updated


on update parameters theObject parameters theParameters
	set |chosenPlaylistName| of theParameters to (the title of popup button "guiExistingPlaylists" of the pContentView) as Unicode text
	return theParameters
end update parameters


on activated theObject
	my updatePlaylistPopup()
end activated


on opened theObject
	my updatePlaylistPopup()
end opened


on updatePlaylistPopup()
	tell progress indicator "guiProgress" of pContentView
		set visible to true
		start
	end tell
	
	set thePlaylists to my iTunesPlaylists()
	
	set thePlaylistPopup to (popup button "guiExistingPlaylists" of the pContentView)
	set theCurrentPlaylist to title of thePlaylistPopup
	
	call method "removeAllItems" of thePlaylistPopup
	call method "addItemsWithTitles:" of thePlaylistPopup with parameter thePlaylists
	
	if theCurrentPlaylist is in thePlaylists then
		set title of thePlaylistPopup to theCurrentPlaylist
	else
		set theCurrentPlaylist to title of thePlaylistPopup
	end if
	
	set |chosenPlaylistName| of pParameters to theCurrentPlaylist as Unicode text
	
	tell progress indicator "guiProgress" of pContentView
		stop
		set visible to false
	end tell
end updatePlaylistPopup


on iTunesPlaylists()
	tell application "iTunes"
		set thePs to (every playlist)
		
		set thePlaylists to {}
		
		repeat with p in thePs
			if class of p is user playlist and smart of p is false then
				copy (name of p) to end of thePlaylists
			end if
		end repeat
	end tell
	
	return thePlaylists
end iTunesPlaylists